using System;
using System.Collections.Generic;

class Program
{
    struct POINT { public double X,Y; public int INDEX; }
    struct EDGE { public int U,V; public double W; public EDGE(int u,int v,double w){U=u;V=v;W=w;} }

    static double MANHATTAN(POINT A, POINT B) => Math.Abs(A.X-B.X)+Math.Abs(A.Y-B.Y);

    static void Main()
    {
        string[] TOK = Console.ReadLine().Split();
        int N = int.Parse(TOK[0]);
        double EPS = double.Parse(TOK[1]);
        POINT[] PTS = new POINT[N];
        for(int I=0;I<N;I++)
        {
            TOK = Console.ReadLine().Split();
            PTS[I] = new POINT{X=double.Parse(TOK[0]),Y=double.Parse(TOK[1]),INDEX=I+1};
        }

        double GRIDSIZE = EPS/2;
        Dictionary<(int,int), POINT> GRID = new Dictionary<(int,int), POINT>();
        foreach(var P in PTS)
        {
            int GX = (int)(P.X/GRIDSIZE);
            int GY = (int)(P.Y/GRIDSIZE);
            var KEY = (GX,GY);
            if(!GRID.ContainsKey(KEY)) GRID[KEY] = P;
        }

        List<POINT> SUBSET = new List<POINT>(GRID.Values);

        Console.WriteLine(SUBSET.Count);
        for(int I=0;I<SUBSET.Count;I++)
            Console.Write(SUBSET[I].INDEX + (I<SUBSET.Count-1?" ":"\n"));

        List<EDGE> EDGES = new List<EDGE>();
        for(int I=0;I<SUBSET.Count;I++)
            for(int J=I+1;J<SUBSET.Count;J++)
                EDGES.Add(new EDGE(I,J,MANHATTAN(SUBSET[I],SUBSET[J])));

        EDGES.Sort((A,B)=>A.W.CompareTo(B.W));
        int[] PARENT = new int[SUBSET.Count];
        for(int I=0;I<SUBSET.Count;I++) PARENT[I]=I;
        Func<int,int> FIND=null;
        FIND=(X)=> PARENT[X]==X?X:(PARENT[X]=FIND(PARENT[X]));
        List<(int,int)> MSTEDGES = new List<(int,int)>();
        foreach(var E in EDGES)
        {
            int U=FIND(E.U),V=FIND(E.V);
            if(U!=V)
            {
                PARENT[U]=V;
                MSTEDGES.Add((SUBSET[E.U].INDEX,SUBSET[E.V].INDEX));
            }
        }

        foreach(var E in MSTEDGES)
            Console.WriteLine($"{E.Item1} {E.Item2}");
    }
}